/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package products;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public interface Item /*extends Comparable*/{
    //Abstract Methods
    public void enterDescription(String comment);
    public String getName();
    public double getPrice();
    public String getFormattedPrice();
    public void setPrice(double price);
    public void printProduct();
    public String getDescription();
    
    //In order to extend comparable need compareTo() method
    //We can use the new 'default' feature of Java SE8 to define 
    //the code here in the interface rather than having to do it
    //in every subtype.
//    @Override
//    default public int compareTo(Object o){
//        //Sort Items by their name
//        if(o instanceof Item){
//            //Use the String's compareTo method to compart the names of 
//            //this product with the product we are comparing it to.
//            return getName().compareTo(((Product) o).getName());
//        } else {
//            //If the object we are comparing it to is not a Product put it at the end.
//            return -1;
//        }
//    }
}
